// Finding the Resonating frequency of a Tuning fork using 
// Autocorrelation method.

//
//OS: windows 7
//Scilab: 5.5.2
//
clc;
close;
clear;
[y,Fs] = wavread('C:\Users\ACER\Desktop\Freq512Hz.wav');
y=y(200:1900); // considering only a segment to reduce the amount of computation
t=(0:length(y)-1)/Fs;
subplot(211)
plot(t,y)
xlabel('Time in seconds')
title('Original signal');
c1=xcorr(y);
subplot(212)
lag=(1:length(c1))-ceil(length(c1)/2);
plot(lag,c1)
title('Autocorrelation if the given segment')

c1 = -c1; //flip the ACF to get two maxima peaks

[a,b] = max(c1); //find the first maxima
[c,d] = max(c1(b+1:$));  //find the second maxima

numsamples = d+1;   //get the number of samples between the peaks

freqncy = Fs/numsamples;   //calculate the frequency of the signal

disp('Resonating frequency in Hz: ');
disp(freqncy);    //display the frequency
